const db = require('../db');

const Contact = {
    getAll: async () => {
        const [rows] = await db.query('SELECT * FROM contacts');
        return rows;
    },
    getById: async (id) => {
        const [rows] = await db.query('SELECT * FROM contacts WHERE id = ?', [id]);
        return rows[0];
    },
    create: async (data) => {
        const { name, phone, email, role, handle, status } = data;
        const [result] = await db.query(
            'INSERT INTO contacts (name, phone, email, role, handle, status) VALUES (?,?,?,?,?,?)',
            [name, phone, email, role || 'Unknown', handle, status || 1]
        );
        return result.insertId;
    },
    getByPhone: async (phone) => {
        const [rows] = await db.query('SELECT * FROM contacts WHERE phone = ?', [phone]);
        return rows[0] || null;
    }
};

module.exports = Contact;
